﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ import Namespace="Soneta.Deklaracje.ZUS" %>
<%@ import Namespace="System.Diagnostics" %>
<%@ import Namespace="System.ComponentModel" %>
<%@ import Namespace="System.Collections.Generic" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Kadry" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<TITLE>Zestawienie IMIR</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
        <script runat="server">

            private class Pozycja {
                
                private string wydzial;
                public string Wydzial {
                    get { return wydzial; }
                }

                private Pracownik prac;
                public Pracownik Prac {
                    get { return prac; }
                }

                private bool miesieczna;

                public string Okresy {
                    get {
                        okresy.Sort();
                        string okr = "";
                        foreach (int okres in okresy) {
                            if (okr != "") okr += "\r\n";
                            int rok = okres / 100;
                            int miesiac = okres - rok * 100;
                            if (miesieczna)
                                okr += new YearMonth(rok, miesiac).ToString();
                            else
                                okr += rok.ToString();
                        }
                        return okr;            
                    }
                }

                List<int> okresy = new List<int>();

                public Pozycja(string wydzial, RMUA rmua) {
                    this.wydzial = wydzial;
                    this.prac = rmua.Pracownik;
                    this.miesieczna = rmua.IsDeklaracjaMiesieczna;
                    Dodaj(rmua);
                }

                public void Dodaj(RMUA rmua) {
                    this.okresy.Add(this.miesieczna ? (rmua.RokMiesiac.Year * 100 + rmua.RokMiesiac.Month) : (rmua.Rok * 100));
                }
            }
        
            public class PrnParams : ContextBase {

                public PrnParams(Context context) : base(context) {
                }

                bool osobno = false;
                [Caption("Wydziały osobno")]
                public bool Osobno {
                    get { return osobno; }
                    set {
                        osobno = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                RMUA.TypOkresuDeklaracji typOkresu = RMUA.TypOkresuDeklaracji.Miesięczna;
                [Caption("Typ deklaracji")]
                public RMUA.TypOkresuDeklaracji TypOkresu {
                    get { return typOkresu; }
                    set {
                        typOkresu = value;
                        OnChanged(EventArgs.Empty);
                    }
                }
            }

            PrnParams pars;
            [Context(Required = true)]
            public PrnParams Params {
                get { return pars; }
                set { pars = value; }
            }
            
            class WydzialComparer : IComparer {
                public int Compare(object ox, object oy) {
                    string x = (string)ox;
                    string y = (string)oy;
                    return x.CompareTo(y);
                }
            }

            class PozycjaWydzialComparer : IComparer<Pozycja> {
                public int Compare(Pozycja x, Pozycja y) {
                    int result = x.Wydzial.CompareTo(y.Wydzial);
                    if (result == 0)
                        result = x.Prac.NazwiskoImię.CompareTo(y.Prac.NazwiskoImię);
                    return result;
                }
            }

            class PozycjaPracownikComparer : IComparer<Pozycja> {
                public int Compare(Pozycja x, Pozycja y) {
                    int result = x.Prac.NazwiskoImię.CompareTo(y.Prac.NazwiskoImię);
                    if (result == 0)
                        result = x.Wydzial.CompareTo(y.Wydzial);
                    return result;
                }
            }

            private string GetWydzial(RMUA rmua) {
                PracHistoria ph = rmua.Pracownik[rmua.Data];
                return ph.Etat.Wydzial != null ? ph.Etat.Wydzial.ToString() : string.Empty;
            }

            bool miesieczna;
            Row[] rows;

            void OnContextLoad(object sender, EventArgs e) {
                miesieczna = pars.TypOkresu == RMUA.TypOkresuDeklaracji.Miesięczna;

                FromTo okres = ((OkresContext)dc[typeof(OkresContext)]).Okres;
                ReportHeader1["OKRES"] = okres.ToString();

                Hashtable ht = new Hashtable();
                rows = (Row[])dc[typeof(Row[])];
                if (pars.Osobno)
                    foreach (RMUA rmua in rows) {
                        if (rmua.IsDeklaracjaMiesieczna != miesieczna)
                            continue;
                        ht[GetWydzial(rmua)] = true;
                    }
                else
                    ht[string.Empty] = true;
                
                ArrayList al = new ArrayList(ht.Keys);
                al.Sort(new WydzialComparer());                
                DataRepeater1.DataSource = al;

                colWydzial.Visible = !pars.Osobno;
                if (pars.Osobno) {
                    Grid1.GroupData0 = "Wydzial";
                    Grid1.GroupLine = "Wydział: {0}";
                }
            }

            void DataRepeater1_BeforeRow(Object sender, EventArgs args) {
                string wydzial = (string)DataRepeater1.CurrentRow;

                List<Pozycja> al = new List<Pozycja>();
                string wdz;

                foreach (RMUA rmua in rows) {
                    if (rmua.IsDeklaracjaMiesieczna != miesieczna)
                        continue;
                    wdz = GetWydzial(rmua);
                    Pozycja pz = al.Find(x => x.Prac == rmua.Pracownik && x.Wydzial == wdz);
                    if (pz != null)
                        pz.Dodaj(rmua);
                    else {
                        pz = new Pozycja(wdz, rmua);
                        if (pars.Osobno) {
                            if (wydzial == wdz)
                                al.Add(pz);
                        }
                        else
                            al.Add(pz);
                    }
                }

                if (pars.Osobno)
                    al.Sort(new PozycjaWydzialComparer());
                else
                    al.Sort(new PozycjaPracownikComparer());
                Grid1.DataSource = al;
            }        
		</script>
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="OnContextLoad"></ea:DataContext>
            <ea:DataRepeater id="DataRepeater1" runat="server" OnBeforeRow="DataRepeater1_BeforeRow" Width="100%">
				<ea:SectionMarker id="SectionMarker1" runat="server"></ea:SectionMarker>
			    <ea:PageBreak id="PageBreak1" runat="server" BreakFirstTimes="False"></ea:PageBreak>
                <eb:ReportHeader id="ReportHeader1" runat="server" title="Zestawienie wystawionych IMIR|Okres: %OKRES%"></eb:ReportHeader>
			    <ea:Grid id="Grid1" runat="server">
				    <Columns>
					    <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP."></ea:GridColumn>
					    <ea:GridColumn runat="server" Align="Left" DataMember="Prac.NazwiskoImię" EncodeHTML="true" Caption="Nazwisko i imię"></ea:GridColumn>
					    <ea:GridColumn runat="server" Align="Left" ID="colWydzial" DataMember="Wydzial" EncodeHTML="true" Caption="Wydział" Width="25"></ea:GridColumn>
					    <ea:GridColumn runat="server" Align="Left" DataMember="Okresy" EncodeHTML="true" Caption="Deklaracja za" Width="14"></ea:GridColumn>
					    <ea:GridColumn runat="server" Caption="Data odbioru" Width="16"></ea:GridColumn>
					    <ea:GridColumn runat="server" Caption="Podpis" Width="20"></ea:GridColumn>
				    </Columns>
			    </ea:Grid>
                <eb:ReportFooter id="ReportFooter1" runat="server"></eb:ReportFooter>
				<ea:SectionMarker id="SectionMarker2" runat="server" SectionType="Footer"></ea:SectionMarker>
            </ea:DataRepeater>
		</FORM>
	</BODY>
</HTML>
